/*____________________________________________________________________________
        Copyright (C) 2000 Networks Associates Technology, Inc.
        All rights reserved.

        $Id: pgpMemPool.h,v 1.6 2001/01/25 22:11:12 jeffc Exp $
____________________________________________________________________________*/

#ifndef Included_pgpMemPool_h
#define Included_pgpMemPool_h


#include "pgpOpaqueStructs.h"
#include "pgpPubTypes.h"
#include "pgpMemoryMgr.h"
#include "pgpTypes.h"

PGP_BEGIN_C_DECLARATIONS


struct MemPool
{
	PGPContextRef	context;
	
	struct PoolBuf *head;
	char *freeptr;
	unsigned freespace;
	unsigned chunksize;	/* Default starting point */
	unsigned long totalsize;
	int (*purge)(void *);	/* Return non-zero to retry alloc */
	void *purgearg;
};



/*
 * Nice clean interfaces
 */
#define memPoolIsEmpty(pool) ((pool)->head == 0)

void 
memPoolInit(PGPContextRef context, MemPool *pool);

void 
memPoolSetPurge(MemPool *pool, int (*purge)(void *), void *arg);

void 
memPoolEmpty(MemPool *pool);

void 
memPoolCutBack(MemPool *dest, MemPool const *cutback);

void  *
memPoolAlloc(MemPool *pool, unsigned len, unsigned alignment);

PGPMemoryMgrRef
pgpMemPoolMemoryMgr( MemPool *pool );


#ifdef DEADCODE
char const  *
memPoolStore(MemPool *pool, char const *str);
#endif

#define memPoolNew(pool, type) memPoolAlloc(pool, sizeof(type), alignof(type))

PGP_END_C_DECLARATIONS

#endif /* Included_pgpMemPool_h */
